﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Messages;
using MCSShared;

namespace VA.TMP.CRM
{
    public class SystemSettingsUpdatePostStageRunner : PluginRunner
    {
        public SystemSettingsUpdatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }

        int numberMatched;
        //bool performSmartMatch = false;
        public override void Execute()
        {
            // TO DO check the name = IEN Import
            if (PrimaryEntity.Attributes.Contains("mcs_name") && PrimaryEntity.Attributes["mcs_name"].ToString().Contains("IENMatching"))
                ImportVistAClinicIENs();
        }

        #region IENImport
        public void ImportVistAClinicIENs()
        {
            numberMatched = 0;
            using (var srv = new Xrm(OrganizationService))
            {
                var bulkUpdate = new ExecuteMultipleRequest
                {
                    Requests = new OrganizationRequestCollection(),
                    Settings = new ExecuteMultipleSettings
                    {
                        ContinueOnError = true,
                        ReturnResponses = true
                    }
                };
                var VistaExport = GetFileIENs(PrimaryEntity.Id, OrganizationService);
                var res = new mcs_resource();
                var clinics = srv.mcs_resourceSet.Where(r => r.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic && r.cvt_ien == null && r.statecode == mcs_resourceState.Active).
                    Select(r => new { r.Id, r.mcs_UserNameInput, r.cvt_ien, r.mcs_Type }).ToList();
                foreach (var clinic in clinics)
                {
                    var ien = MatchName(clinic.mcs_UserNameInput, VistaExport);
                    if (!string.IsNullOrEmpty(ien))
                    {

                        var request = new UpdateRequest()
                        {
                            Target = new mcs_resource
                            {
                                cvt_ien = ien,
                                Id = clinic.Id
                            }
                        };
                        bulkUpdate.Requests.Add(request);
                        if (bulkUpdate.Requests.Count % 1000 == 0)
                        {
                            bulkUpdate = RunExecuteMultiple(bulkUpdate);
                        }
                    }

                }
                //Ended loop with uneven number of submitted requests, so doing one final ExecuteMultiple
                Logger.WriteDebugMessage(string.Format("Additional Clinics to Process: {0}", bulkUpdate.Requests.Count));

                if (bulkUpdate.Requests.Count > 0)
                {
                    RunExecuteMultiple(bulkUpdate);
                }
                Logger.WriteToFile(string.Format("Matched: {0}.  Did not match: {1}.  Total Processed: {2}.", numberMatched, clinics.Count - numberMatched, clinics.Count));
            }
        }

        private ExecuteMultipleRequest RunExecuteMultiple(ExecuteMultipleRequest bulkUpdate)
        {
            try
            {
                ExecuteMultipleResponse resp = (ExecuteMultipleResponse)OrganizationService.Execute(bulkUpdate);
                var errors = resp.Responses.Where(r => r.Fault != null).ToList();
                var errorString = string.Empty;
                foreach(var error in errors)
                {
                    Logger.WriteToFile(string.Format("Failed to update request #{0}.  Error details {1}", error.RequestIndex, ReadFaults(error.Fault, "")));
                }
                Logger.WriteDebugMessage(string.Format("Bulk Update returned {0} errors", errors.Count));
                bulkUpdate.Requests.Clear();
            } catch (Exception ex)
            {
                Logger.WriteToFile(string.Format("Failed to UpdateMultiple: {0}.  Full exception List {1}", CvtHelper.BuildExceptionMessage(ex)));
            }
            return bulkUpdate;
        }

        private string ReadFaults(OrganizationServiceFault fault, string errorMessage)
        {
            var message = string.Format("{2} {0} \n{1}\n", errorMessage, fault.Message);
            if (fault.InnerFault != null)
                ReadFaults(fault.InnerFault, message);
            return message;
        }

        private string MatchName(string clinicName, List<KeyValuePair<string, string>> VistaExport, int depth = 1)
        {
            Logger.WriteDebugMessage(string.Format("Match attempt #{0} for {1}", depth, clinicName));
            var match = VistaExport.FirstOrDefault(vistaLocation => vistaLocation.Key == clinicName);
            var ien = match.Value ?? string.Empty;
            if (!string.IsNullOrEmpty(ien))
                numberMatched++;
            //else if (performSmartMatch && depth < 5)
            //    ien = SmartMatchIen(clinicName, VistaExport, depth);
            return ien;
        }

        //private string SmartMatchIen(string clinicName, List<KeyValuePair<string, string>> VistaExport, int depth)
        //{
        //    depth++;
        //    var originalName = clinicName;
        //    if (clinicName.ToLower().StartsWith("zz") || clinicName.StartsWith("*"))
        //        clinicName = clinicName.Trim('*', 'z', 'Z').Trim();
        //    else if (clinicName.Contains("TH"))
        //        clinicName = clinicName.Replace("TH", "TELE");
        //    if (originalName != clinicName)
        //        return MatchName(clinicName, VistaExport, depth);
        //    else
        //        Logger.WriteDebugMessage(string.Format("Unable to find relevant transformation for {0}.  Moving on to next clinic.  ", clinicName));
        //    return string.Empty;
        //}

        private List<KeyValuePair<string, string>> GetFileIENs(Guid id, IOrganizationService orgService)
        {
            Logger.WriteDebugMessage("Getting File IEN List");
            //var note = new Annotation();
            //using (var srv = new Xrm(OrganizationService))
            //    note = srv.AnnotationSet.FirstOrDefault(n => n.ObjectId.Id == id);
            //if (note == null)
            //    throw new InvalidPluginExecutionException(string.Format("Unable to get Note for record: {0}", id));
            //return ConvertFileToList(note);

            var notes = new List<Annotation>();
            using (var srv = new Xrm(OrganizationService))
                notes = srv.AnnotationSet.Where(n => n.ObjectId.Id == id).ToList();
            var file = new List<KeyValuePair<string, string>>();
            foreach(var n in notes)
            {
                file.AddRange(ConvertFileToList(n));
            }
            return file;
        }

        private List<KeyValuePair<string, string>> ConvertFileToList(Annotation note)
        {
            Logger.WriteGranularTimingMessage("Begin File Conversion");
            var IENList = new List<KeyValuePair<string, string>>();
            var rawFile = Convert.FromBase64String(note.DocumentBody.ToString());
            var fileString = System.Text.Encoding.UTF8.GetString(rawFile);

            var lineBreak = Environment.NewLine;
            var lines = fileString.Split(lineBreak.ToCharArray());
            foreach (var line in lines)
            {
                var items = line.Split(',');
                if (items.Length > 1)
                    IENList.Add(new KeyValuePair<string, string>(items[0], items[1]));
            }
            Logger.WriteGranularTimingMessage("Completed File Conversion");
            return IENList;
        }
        #endregion
      
        public override string McsSettingsDebugField
        {
            get { return "mcs_serviceplugin"; }
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.PostEntityImages["post"];
        }

        private Dictionary<string, List<string>> NameMatches = new Dictionary<string, List<string>> {
            { "TH", new List<string>() { "Tele", "TH", "Telehealth" } },
            { "Ind", new List<string>() { "Indiv", "Indi", "Individual" } }

        };

        private List<List<string>> NameGroups = new List<List<string>>
        {
            new List<string>() { "Audiology", "Aud", "Audio", "Audiololy" },
            new List<string>() { "GRP", "Group", "GP" },
            new List<string>() { "Ind", "Indiv", "Indi", "Individual" },
            new List<string>() { "Nutr","Nutri","Nut","Nutrition" }
        };

    }
}
